<?php
/**
 * Plugin Name: Custom Post Types
 * Plugin URI: http://spyropress.com
 * Description: Custom Post Types for Theme.
 * Version: 1.0.0
 * Author: ThemeSquared
 * Author URI: http://spyropress.com
 *
 * Requires at least: 3.8
 * Tested up to: 4.2.3
 *
 * Text Domain: spyropress
 * 
 *
 * @package     ThemeSquared
 * @author      ThemeSquared
 * @version     1.0.0
*/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 *  Class - Loads and Initialize the framework.
 *
 * @class SpyropressCPT
 * @version 3.7
 */
final class SpyropressCPT {
    
     /** SpyropressCPT Constructor, Gets things started **/
    public function __construct() {

        // Include core files
        $this->includes();
        
        // Init Custom Post Types and Taxonomies
        add_action( 'after_setup_theme', array( $this, 'init_components' ), 11 );
    }
    
    // Include required core files used in admin and on the frontend.
	private function includes() {
	   
       do_action( 'before_spyropress_cpt_core_includes' ); 
           
            $includes = array(
                'includes/class-custom-post-type.php',
            );
    
            foreach ( $includes as $i ){
                require_once ( $i );
            }
            
                
        // Allow developers to include files before framework initialize
        do_action( 'after_spyropress_cpt_core_includes' );
	}
    
    /** Init Components **/
    function init_components() {

        // Get theme-supported menus.
        $components = get_theme_support( 'spyropress-components' );
        

        // If there is no components, return.
        if ( ! is_array( $components[0] ) ) return;

        $path = $this->plugin_path().'includes/components/';
        
        // Register Components
        foreach ( $components[0] as $component ) {
            
            $file = $path . $component . '/' . $component . '-init.php';
        	if ( file_exists( $file ) ) {
        	   include_once($file);
        	}
            
            $file = $path  . $component . '.php';
            if ( file_exists( $file ) ) {
        	   include_once($file);
        	}
        }
    }
    
    /** ========= URI/PATH HELPERS ========= */
	// Get the plugin path.
	function plugin_path() {
		return trailingslashit( plugin_dir_path( __FILE__ ) );
	}
    
    
}

/**
 * Returns the main instance of Spyropress
 *
 * @return SpyropressCPT Object
 */
function SpyropressCPT() {
	return $GLOBALS['SpyropressCPT'];
}

/**
 * Init SpyropressCPT Engine
 */
add_action( 'plugins_loaded', 'SpyropressCPTActive', 8 );

function SpyropressCPTActive(){
    $GLOBALS['SpyropressCPT'] = new SpyropressCPT();
}
