<?php

/**
 * Pricing Table Component
 *
 * @package		SpyroPress
 * @category	Components
 */


class SpyropressPricingTable extends SpyropressComponent {

    private $path;

    function __construct() {

        $this->path = dirname(__FILE__);
        add_action( 'spyropress_register_taxonomy', array( $this, 'register' ) );
        add_shortcode( 'pricing_table',  array( $this, 'shortcode_handler' ) );
    }

    function register() {

        // Init Post Type
        $args = array(
            'public' => false,
            'show_in_admin_bar' => true,
            'supports' => array( 'title' ),
            'has_archive' => false,
            'query_var' => false,
            'menu_icon' => 'dashicons-media-spreadsheet'
        );
        $post_type = new SpyropressCustomPostType( __( 'Pricing Table', 'sonno' ), 'pricingtable', $args );

        // Shortcode Meta Box
        $instructions = '<p>' . __( 'Display price table anywhere into your posts, pages, custom post types or widgets by using the shortcode below:', 'sonno' ) . '</p>';
        $instructions .= '<p><code>[pricing_table id={post_id}]</code></p>';

        $sc_fields['shortcode'] = array(
            array(
                'label' => __( 'Shortcode', 'sonno' ),
                'type' => 'heading',
                'slug' => 'shortcode'
            ),

            array(
                'id' => 'instruction_info',
                'type' => 'raw_info',
                'function' => array( $this, 'set_post_id' ),
                'desc' => $instructions,
            ),

            array(
                'id' => 'template',
                'label' => __( 'Columns', 'sonno' ),
                'type' => 'select',
                'class' => 'section-full',
                'options' => array(
                    'col-md-4' => __( '3 Columns', 'sonno' ),
                    'col-md-3' => __( '4 Columns', 'sonno' ),
                ),
                'std' => 'col-md-4'
            ),
            
            array(
                'label' => __( 'Currency', 'sonno' ),
                'id' => 'currency',
                'class' => 'section-full',
                'std' => '$'
            ),
            
            array(
                'id' => 'button_text',
                'label' => __( 'Button Text', 'sonno' ),
                'type' => 'text',
                'class' => 'section-full',
                'std' => 'Get it now'
            ),
        );

        $post_type->add_meta_box( 'shortcode', __( 'Shortcode & General Settings', 'sonno' ), $sc_fields, false, false, 'side' );

        // Add Meta Boxes
        $meta_fields['table'] = array(
            array(
                'label' => __( 'Table', 'sonno' ),
                'type' => 'heading',
                'slug' => 'table'
            ),

            array(
                'label' => __( 'Table', 'sonno' ),
                'type' => 'repeater',
                'id' => 'tables',
                'item_title' => 'title',
                'hide_label' => true,
                'fields' => array(

                    array(
                        'label' => __( 'Title', 'sonno' ),
                        'id' => 'title',
                        'type' => 'text'
                    ),

                    array( 'type' => 'row' ),

                        array( 'type' => 'col', 'size' => 6 ),

                            array(
                                'label' => __( 'Price', 'sonno' ),
                                'id' => 'price',
                                'type' => 'text'
                            ),

                        array( 'type' => 'col_end' ),

                        array( 'type' => 'col', 'size' => 6 ),

                            array(
                                'label' => __( 'Button URL', 'sonno' ),
                                'id' => 'url',
                                'type' => 'text'
                            ),

                        array( 'type' => 'col_end' ),

                    array( 'type' => 'row_end' ),

                    array(
                        'label' => __( 'Description', 'sonno' ),
                        'id' => 'description',
                        'type' => 'textarea',
                        'rows' => 4
                    ),

                    array(
                        'label' => __( 'Features', 'sonno' ),
                        'type' => 'repeater',
                        'id' => 'features',
                        'item_title' => 'title',
                        'fields' => array(
                            array(
                                'label' => __( 'Title', 'sonno' ),
                                'id' => 'title',
                                'type' => 'text'
                            )
                        )
                    ),
                    
                    array(
                        'label' => __( 'Type', 'sonno' ),
                        'id' => 'type',
                        'type' => 'select',
                        'options' => array(
                            'default' => __( 'Default', 'sonno' ),
                            'primary' => __( 'Primary', 'sonno' ),
                            'secondary' => __( 'Secondary', 'sonno' ),
                            'tertiary' => __( 'Tertiary', 'sonno' )
                        )
                    )
                )
            )
        );

        $post_type->add_meta_box( 'tables', __( 'Tables', 'sonno' ), $meta_fields, false, false );
    }

    /**
     * Callback for post_ID for instruction box
     */
    function set_post_id( $output ) {
        global $post;
        return str_replace( '{post_id}', $post->ID, $output );
    }

    /**
     * Shortcode handler
     */
    function shortcode_handler( $atts, $content = '' ) {

        // check
        if( ! isset( $atts['id'] ) || empty( $atts['id'] ) ) return;

        $slider_id = $atts['id'];

        // get slider meta
        $meta = get_post_custom( $slider_id );

        // get slider type
        $columns = maybe_unserialize( $meta['tables'][0] );
        if( empty( $columns ) ) return;

        if( isset( $meta['template'] ) )
            $template = maybe_unserialize( $meta['template'][0] );

        $func = "spyropress_render_table_pricing_items";
        return $this->{$func}( $columns, $meta );
    }

    function spyropress_render_table_pricing_items( $columns, $meta ) {
        
        // get slider type
        $column_class = array();
        $column_class[] = maybe_unserialize( $meta['template'][0] );
        $currency = maybe_unserialize( $meta['currency'][0] );
        $button_text = maybe_unserialize( $meta['button_text'][0] );
        
        
        $tables = '';
        foreach( $columns as $column ) {
            $class = '';
            if( isset( $column['type'] ) ){
                $class = $column['type'];
            }

            $features = '';
            foreach( $column['features'] as $feature ) {
                $features .= '<li>' . $feature['title'] . '</li>';
            }

            $tables .= '
            <div class="'. esc_attr( spyropress_clean_cssclass( $column_class ) ) .'">
                <!-- Start Pricing Default -->
                <div class="pricing-table '. esc_attr( $class ) .'">
                    <div class="pricing-header">
                        <h4>' . esc_html( $currency ) .'<span class="price">'. esc_html( $column['price'] ) .'</span><span class="mon">'. esc_html( $column['description'] ) .'</span></h4>
                    </div>
                    <div class="pricing-title">
                        <h5>' . esc_html( $column['title'] ) . '</h5>
                    </div>
                    <div class="pricing-list">
                        <ul>
                            ' . $features . '
                        </ul>
                    </div>
                    <div class="pricing-footer">
                        <a href="' . esc_url( $column['url'] ) . '" class="btn btn-'. $class .' btn-bavel">' . esc_html( $button_text ) . '</a>
                    </div>
                </div>    
                <!-- End Pricing Default -->
            </div>';
        }
        return '<div class="row">' . $tables . '</div>';
    }

    function register_module( $modules ) {

        $modules[] = $this->path . '/module/price-table.php';

        return $modules;
    }
}

/**
 * Init the Component
 */
new SpyropressPricingTable();