<?php

/**
 * Post Component
 * 
 * @package		SpyroPress
 * @category	Components
 */

class SpyropressPost extends SpyropressComponent {

    private $path;
    
    function __construct() {

        $this->path = dirname(__FILE__);
        add_action( 'spyropress_register_taxonomy', array( $this, 'register' ) );
    }

    function register() {

        // Init Post Type
        $post = new SpyropressCustomPostType( 'Post' );
        
        // Add Meta Boxes
        $meta_fields['options'] = array(
            array(
                'label' => __( 'Post Option', 'sonno' ),
                'type' => 'heading',
                'slug' => 'post'
            ),
            
            array(
                'label' => __( 'Type', 'sonno' ),
                'id' => 'type',
                'type' => 'select',
                'desc' => __( 'Choose Color OF Post For Blog Module', 'sonno' ),
                'options' => array(
                    'primary' => __( 'Primary', 'sonno' ),
                    'secondary' => __( 'Secondary', 'sonno' ),
                    'tertiary' => __( 'Tertiary', 'sonno' ),
                    'quaternary' => __( 'Quaternary', 'sonno' )
                ),'std' => 'primary'
            )
        );
        
        $post->add_meta_box( 'post_options', __( 'Post Options', 'sonno' ), $meta_fields, false, false, 'normal', 'high' );
    }
}

/**
 * Init the Component
 */
new SpyropressPost();
?>