<?php

/**
 * Module: Portfolio
 * Display a list of portfolio
 *
 * @author 		SpyroSol
 * @category 	BuilderModules
 * @package 	Spyropress
 */

class Spyropress_Module_Portfolio extends SpyropressBuilderModule {

    public function __construct() {

        // Widget variable settings.
        $this->path = dirname( __FILE__ );
        $this->cssclass = 'module-portfolio';
        $this->description = __( 'Display a list of portfolio.', 'sonno' );
        $this->id_base = 'spyropress_portfolio';
        $this->name = __( 'Recent Portfolio', 'sonno' );

        // Fields
        $this->fields = array(

            array(
                'label' => __( 'Title', 'sonno' ),
                'id' => 'title',
                'type' => 'text',
                'std' => $this->name
            ),

            array('type' => 'row'),
                array('type' => 'col', 'size' => 6),
                array(
                    'label' => __( 'Number of items per page', 'sonno' ),
                    'id' => 'limit',
                    'type' => 'range_slider',
                    'max' => 30,
                    'std' => 4
                ),
                
                array('type' => 'col_end'),
            
                array('type' => 'col', 'size' => 6),
                array(
                    'label' => __( 'Portfolio Category', 'sonno' ),
                    'id' => 'cat',
                    'type' => 'multi_select',
                    'options' => spyropress_get_taxonomies( 'portfolio_category' )
                ),
    
                array(
                    'label' => __('Pagination', 'sonno'),
                    'id' => 'settings',
                    'type' => 'checkbox',
                    'desc' => 'Will show pagination if portfolio per page is set.',
                    'options' => array(
                        'pagination' => __( 'Enable pagination for the next page','sonno' ), 
                        'filters' => __( 'Enable category filter', 'sonno' ),
                    )
                ),
                array('type' => 'col_end'),
                
            array('type' => 'row_end'),
        );

        $this->create_widget();
    }

    function widget( $args, $instance ) {
        
        // extracting info
        extract( $args );

        // get view to render
        include $this->get_view();
    }
    
    function query( $atts, $content = null ) {

        $default = array (
            'post_type' => 'portfolio',
            'limit' => -1,
            'columns' => false,
            'row' => false,
            'pagination' => false,
            'callback' => array( $this, 'spyropress_generate_portfolio_item' )
        );
        $atts = wp_parse_args( $atts, $default );
    
        if ( ! empty( $atts['cat'] ) ) {
    
            $atts['tax_query']['relation'] = 'OR';
            if ( ! empty( $atts['cat'] ) ) {
                $atts['tax_query'][] = array(
                    'taxonomy' => 'portfolio_category',
                    'field' => 'slug',
                    'terms' => $atts['cat'],
                    );
                unset( $atts['cat'] );
            }
        }
    
        if ( $content )
            return token_repalce( $content, spyropress_query_generator( $atts ) );
    
        return spyropress_query_generator( $atts );
    }
    
    // Item HTML Generator
    function spyropress_generate_portfolio_item( $post_ID, $atts ) {
    
        // these arguments will be available from inside $content
        $image = array(
            'post_id' => $post_ID,
            'echo' => false,
            'class' => 'img-responsive'
        );
        $image_tag = spyropress_get_image( $image );
        
        $image['width'] = 9999;
        $image['type'] = 'src';
        $image_url = spyropress_get_image( $image );
        
        $terms = get_the_terms( $post_ID, 'portfolio_category' );
        $cats = array(); $category = '';
        if ( !is_wp_error( $terms ) && !empty($terms ) ) {
            foreach ( $terms as $term ) {
                $cats[] = $term->slug;
            }
            $category = '<a href="#" class="category">'. join( ' ', $cats ) .'</a>';
        }
        
        //testimonial meta data.
        $spyropress_data = get_post_meta( $post_ID, '_portfolio_details', true );
        
        
        $class = isset( $spyropress_data['spyropress_img_big'] )? 'col-md-6 col-sm-4 col-xs-6' : 'col-md-3 col-sm-4 col-xs-6';
        // item tempalte
        $item_tmpl = '
        <div data-filter="'. join( ' ', $cats ) .'" class="grid-item '. esc_attr( $class ) .' img-hover">
            <div class="dh-overlay">
                <div class="option">
                    <a href="'. $image_url .'" class="zoom" data-pretty="prettyPhoto"><span class="icon icon-magnifying-glass"></span></a>
                    <h5>
                        <a href="'. get_permalink() .'" class="title">'. get_the_title() .'</a>
                        '. $category .'
                    </h5>
                </div>
            </div>
            '. $image_tag .'
        </div>';
        
        return $item_tmpl;
    }
}
//Register Module Class Spyropress_Module_Portfolio
spyropress_builder_register_module( 'Spyropress_Module_Portfolio' );
