<?php
/**
 * Plugin Name: Custom Post Types
 * Plugin URI: http://spyropress.com
 * Description: Custom Post Types for Theme.
 * Version: 1.0.0
 * Author: ThemeSquared
 * Author URI: http://spyropress.com
 *
 * Requires at least: 3.8
 * Tested up to: 4.2.3
 *
 * Text Domain: spyropress
 * 
 *
 * @package     ThemeSquared
 * @author      ThemeSquared
 * @version     1.0.0
*/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 *  Class - Loads and Initialize the framework.
 *
 * @class SpyropressCPT
 * @version 3.7
 */
final class SpyropressCPT {
    
    /** Variblaes ***************************************************************/
    var $admin_menu_parent;
    var $admin_menus;
    
     /** SpyropressCPT Constructor, Gets things started **/
    public function __construct() {

        // Include core files
        $this->includes();
        
        // Init Custom Post Types and Taxonomies
        add_action( 'init', array( $this, 'construct_plugin_admin_menu' ), 2 );
        add_action( 'admin_menu', array( $this, 'add_plugin_admin_menu' ), 9 );
        add_action( 'after_setup_theme', array( $this, 'init_components' ), 11 );
        
    }
    
    /**
     * Spyropress Menu/Pages Function
     * Create spyropress menu array for the admin pages.
     */
    function construct_plugin_admin_menu() {

        global $spyropress;
        
        // Dashboard
        $this->admin_menu_parent = array(
            'page_title' => esc_html__( 'Welcome to ThemeSquared', 'heartify' ),
            'menu_title' => esc_html__( 'ThemeSquared', 'heartify' ),
            'slug' => 'spyropress',
            'position' => '55'
        );

        $this->admin_menus['spyropress'] = array(
            'page_title' => esc_html__( 'Welcome to ThemeSquared', 'heartify' ),
            'menu_title' => esc_html__( 'Dashboard', 'heartify' ),
            'page_file' => 'page-dashboard.php',
            'isactive' => true,
            'hidden' => false
        );

        // Get theme-supported options
        $registered_options = get_theme_support( 'spyropress-options' );

        if ( ! empty( $registered_options ) ) {
            foreach ( $registered_options[0] as $option => $option_meta ) {
                $key = 'spyropress-' . $option;
                $this->admin_menus[$key] = array_merge( $option_meta, array( 'page_file' => 'page-option-machine.php', ) );
            }
        }

        if ( $spyropress->is_builder_verified ) {

            $count = ( is_theme_updateable() ) ? '<span class="update-plugins count-1"><span class="update-count">1</span></span>' : '';

            $this->admin_menus['spyropress-update'] = array(
                'page_title' => esc_html__( 'Theme Updates', 'heartify' ),
                'menu_title' => esc_html__( 'Theme Updates', 'heartify' ) . $count,
                'page_file' => 'page-theme-update.php',
                'isactive' => true,
                'hidden' => false
            );
        }
    }
    
    /**
     * Add admin pages link to menu
     */
    function add_plugin_admin_menu() {
        
        $parent_slug = $this->admin_menu_parent['slug'];

        // add parent menus
        $main_page = add_menu_page( $this->admin_menu_parent['page_title'], $this->admin_menu_parent['menu_title'], 'manage_options', $this->admin_menu_parent['slug'], array( $this, 'load_custom_pages' ), '', $this->admin_menu_parent['position'] );

        // add child menus
        foreach ( $this->admin_menus as $slug => $menu ) {
            $item = ( object )$menu;
            if ( $item->isactive ){
            add_submenu_page( ( ! $item->hidden ) ? $parent_slug : null, $item->page_title, $item->menu_title, 'manage_options', $slug, array( $this, 'load_custom_pages' ) );    
            }
            
        }

        do_action( 'spyropress_admin_css' );
    }
    
    /**
     * Admin Pages Callback Function
     */
    function load_custom_pages() {
        $page = $this->admin_menus[$_GET['page']]['page_file'];
        load_template( get_template_directory()."/framework/admin/$page", true );
    }
    
    // Include required core files used in admin and on the frontend.
	private function includes() {
	   
       do_action( 'before_spyropress_cpt_core_includes' ); 
           
            $includes = array(
                'includes/class-custom-post-type.php',
            );
    
            foreach ( $includes as $i ){
                require_once ( $i );
            }
            
                
        // Allow developers to include files before framework initialize
        do_action( 'after_spyropress_cpt_core_includes' );
	}
    
    /** Init Components **/
    function init_components() {

        // Get theme-supported menus.
        $components = get_theme_support( 'spyropress-components' );
        

        // If there is no components, return.
        if ( ! is_array( $components[0] ) ) return;

        $path = $this->plugin_path().'includes/components/';
        
        // Register Components
        foreach ( $components[0] as $component ) {
            
            $file = $path . $component . '/' . $component . '-init.php';
        	if ( file_exists( $file ) ) {
        	   include_once($file);
        	}
            
            $file = $path  . $component . '.php';
            if ( file_exists( $file ) ) {
        	   include_once($file);
        	}
        }
    }
    
    /** ========= URI/PATH HELPERS ========= */
	// Get the plugin path.
	function plugin_path() {
		return trailingslashit( plugin_dir_path( __FILE__ ) );
	}
    
    
}

/**
 * Returns the main instance of Spyropress
 *
 * @return SpyropressCPT Object
 */
function SpyropressCPT() {
	return $GLOBALS['SpyropressCPT'];
}

/**
 * Init SpyropressCPT Engine
 */
add_action( 'plugins_loaded', 'spyropress_CPT', 8 );
function spyropress_CPT(){
   $GLOBALS['SpyropressCPT'] = new SpyropressCPT();
}

/**
 * Helper function to return encoded strings
 */
function spyropress_plugin_encode( $value ) {

    return base64_encode( serialize( $value ) );

}

/**
 * Helper function to return decoded strings
 */
function spyropress_plugin_decode( $value ) {

    return unserialize( base64_decode( $value ) );

}

/**
 * Include Twitter Module.
 */
function spyropress_register_plugin_builder_modules( $modules ) {
    global $SpyropressCPT;
    $spyropress_modules[] = $SpyropressCPT->plugin_path().'includes/components/twitter/twitter.php';
    
    return $spyropress_modules;
}
add_filter( 'builder_plugin_include_modules', 'spyropress_register_plugin_builder_modules' );