<?php

/**
 * Module: Staff
 * Display a list of staff
 *
 * @author 		SpyroSol
 * @category 	BuilderModules
 * @package 	Spyropress
 */

class Spyropress_Module_Staff extends SpyropressBuilderModule {

    public function __construct() {

        // Widget variable settings.
        $this->path = dirname( __FILE__ );
        $this->description = __( 'Display a list of staff.', 'sonno' );
        $this->id_base = 'spyropress_staff';
        $this->name = __( 'Our Team', 'sonno' );
        
        // Fields
        $this->fields = array(
            
            array(
                'label' => __( 'Number of Items', 'sonno' ),
                'id' => 'limit',
                'type' => 'range_slider',
                'std' => 4,
                'max' => 20
            ),
            
            
            array(
                'label' => __( 'Portfolio Category', 'sonno' ),
                'id' => 'cat',
                'type' => 'multi_select',
                'options' => spyropress_get_taxonomies( 'staff_category' )
            )
            
        );

        $this->create_widget();
    }

    function widget( $args, $instance ) {

        // extracting info
        extract( $args );extract( $instance );
        
        // get view to render
        include $this->get_view();
    }

    function query( $atts, $content = null ) {

        $default = array (
            'post_type' => 'staff',
            'limit' => -1,
            'pagination' => false,
            'callback' => array( $this, 'generate_item_top_image' ),
            'row' => false,
            'column_class' => 'team-item',
            'columns' => 4
        );
        $atts = wp_parse_args( $atts, $default );
        
        if ( ! empty( $atts['cat'] ) ) {
            $atts['tax_query']['relation'] = 'OR';
            if ( ! empty( $atts['cat'] ) ) {
                $atts['tax_query'][] = array(
                    'taxonomy' => 'staff_category',
                    'field' => 'slug',
                    'terms' => $atts['cat'],
                    );

                unset( $atts['cat'] );
            }
        }

        if ( $content )
            return token_repalce( $content, spyropress_query_generator( $atts ) );

        return spyropress_query_generator( $atts );
    }

    function generate_item_top_image( $post_ID, $atts ) {

        // these arguments will be available from inside $content
        $image = array(
            'post_id' => $post_ID,
            'echo' => false,
            'width' => 9999,
            'responsive' => true,
        );
        $image_tag = spyropress_get_image( $image );
        
        //post meta data value
        $info = get_post_meta( $post_ID, '_mate_info', true );
        
        if( isset( $info['social_icons'] ) ):
            $socials_icons = '';
            foreach( $info['social_icons'] as $socials ){
                $socials_icons .= '<li><a href="'. esc_url( $socials['link'] ) .'"><span class="icon '. esc_attr( $socials['network'] ) .'"></span></a></li>';
            }
            $socials_icons = '<ul>'. $socials_icons .'</ul>';    
        
        endif; 
        
        
        $terms = get_the_terms( $post_ID, 'designation' );
        $terms_name =  array();
        if( !empty( $terms ) && !is_wp_error( $terms ) ) {
            foreach( $terms as $term )
                $terms_name[] = $term->name;
        }
        
        $class = '';
        if( isset( $info['type'] ) ){
            $class = $info['type'];
        }
            
        // item tempalte
        return '
        <div class="team-item '. $class .'">
            '. $image_tag .'
            <div class="caption">
                <h5>'. get_the_title() .'</h5>
                <h6>' . join( ', ', $terms_name ) . '</h6>
                '. $socials_icons .'
            </div>
        </div>';
        
    }

}
//Register Module Class Spyropress_Module_Staff.
spyropress_builder_register_module( 'Spyropress_Module_Staff' );