<?php

/**
 * Flex Slider
 * Related functions
 */

/**
 * Slides Options
 */
function get_flexslides_setting() {
    
    $slides = array(
        array(
            'label'  => __( 'Slides', 'sonno' ),
            'type' => 'heading',
            'icon' => 'general',
            'slug' => 'instruction'
        ),
        
        array(
    		'label' => __( 'Slides', 'sonno' ),
    		'type' => 'repeater',
            'id' => 'slides',
            'fields' => array(
                array(
            		'label' => __( 'Slide', 'sonno' ),
            		'type' => 'repeater',
                    'id' => 'slide',
                    'fields' => array(
                        array(
                            'label' => __( 'Type', 'sonno' ),
                            'id' => 'type',
                            'type' => 'select',
                            'options' => array(
                                'image' => __( 'Image', 'sonno' ),
                                'caption' => __( 'Caption', 'sonno' )
                            ),
                            'std' => 'image'
                        ),
        
                        array(
                            'label' => __( 'Content', 'sonno' ),
                            'id' => 'content',
                            'type' => 'textarea',
                            'rows' => 5
                        ),
                        
                        array(
                            'label' => __( 'Image', 'sonno' ),
                            'id' => 'image',
                            'type' => 'upload'
                        ),
                        
                        array(
                            'label' => __( 'Slide Setting', 'sonno' ),
                            'type' => 'sub_heading'
                        ),
        
                        array(
                            'label' => __( 'Translation', 'sonno' ),
                            'id' => 'translation',
                            'type' => 'select',
                            'options' => array(
                                'ZMS|B' => __( 'ZMS|B', 'sonno' ),
                                'CLIP|LR' =>  __( 'CLIP|LR', 'sonno' ),
                                'R|IB' =>  __( 'R|IB', 'sonno' ),
                                'ZMS|B' =>  __( 'ZMS|B', 'sonno' ),
                            ),'std' => 'R|IB'
                        ),
        
                        array(
                            'label' => __( 'Postion Horiziontial', 'sonno' ),
                            'id' => 'postion_x',
                            'type' => 'text',
                        ),
                        
                        array(
                            'label' => __( 'Postion Vertical', 'sonno' ),
                            'id' => 'postion_v',
                            'type' => 'text',
                        ),
                        
                        array(
                            'label' => __( 'Class Extra', 'sonno' ),
                            'id' => 'class_extra',
                            'type' => 'text',
                        )
                    )
                )
            )
        )
    );

    return $slides;
}

/**
 * Enqueue Style and Script
 */
function enqueue_flexslider_assets() {
    wp_enqueue_script( 'spyropress-jssor', template_url() . 'assets/js/jssor-slider/jssor.js', false, false );
    wp_enqueue_script( 'spyropress-jssor-slider', template_url() . 'assets/js/jssor-slider/jssor.slider.js', false, false, true );
    wp_enqueue_script( 'spyropress-jssor-setting', template_url() . 'assets/js/jssor-slider/setting.js', false, false, true );
}


/**
 * Generate Markup
 */
function flexslider_shortcode_handler( $slider_id, $slides, $settings = '' ) {

    $out = '';
    $out .= '<div id="slider2_container" class="slider2_container"><div data-jssor="slides" class="slides">';
    foreach ( $slides as $slide_item ) {
        $out .= '<div>';
        foreach( $slide_item['slide'] as $slide ){
            
            if( 'image' == $slide['type'] ){
                $out .= '<img data-jssor="image" src="'. $slide['image'] .'" alt="" />';
            }elseif( 'caption' == $slide['type'] ){
                $out .= 
                '<div data-jssor="caption" data-trans="'. $slide['translation'] .'" class="jssor-cap '. $slide['class_extra'] .'" style="left:'. $slide['postion_x'] .'px;top:'. $slide['postion_v'] .'px;">
                    '. $slide['content'] .'
                </div>';
            }
        } 
        $out .= '</div>';
    }
    $out .= '</div></div>';

    return $out;
}
?>