<?php

/**
 * Portfolio Component
 *
 * @package		SpyroPress
 * @category	Components
 */

class SpyropressPortfolio extends SpyropressComponent {

    private $path;
    
    function __construct() {

        $this->path = dirname(__FILE__);
        add_action( 'spyropress_register_taxonomy', array( $this, 'register' ) );
        add_filter( 'builder_include_modules', array( $this, 'register_module' ) );
    }

    function register() {

        // Init Post Type
        $args = array(
            'supports'      => array( 'title', 'editor', 'thumbnail' ),
            'has_archive'   => false,
            'exclude_from_search' => true,
            'rewrite' => array( 'slug' => get_setting( 'portfolio-slug', 'portfolio' ) ),
            'menu_icon' => 'dashicons-portfolio'
        );
        $post = new SpyropressCustomPostType( __( 'Portfolio', 'sonno' ), '', $args );
        
        // Add Taxonomy
        $post->add_taxonomy( __( 'Category', 'sonno' ), 'portfolio_category', __( 'Portfolio Categories', 'sonno' ), array( 'hierarchical' => true ) );
        
        // Add Meta Boxes
        $meta_fields['portfolio'] = array(
            array(
                'label' => __( 'Portfolio', 'sonno' ),
                'type' => 'heading',
                'slug' => 'portfolio'
            ),
            
            array(
                'label' => __( 'Type', 'sonno' ),
                'id' => 'spyropress_type',
                'type' => 'text'
            ),
    
            array(
                'label' => __( 'Size', 'sonno' ),
                'id' => 'spyropress_size',
                'type' => 'text'
            ),
            
            array(
                'label' => __( 'Licence', 'sonno' ),
                'id' => 'spyropress_licence',
                'type' => 'text'
            ),
            
            array(
                'label' => __( 'Licence Url', 'sonno' ),
                'id' => 'spyropress_licence_url',
                'type' => 'text'
            ),

            
            array(
                'label' => __( 'Project URL', 'sonno' ),
                'type' => 'repeater',
                'id' => 'spyropress_links',
                'item_title' => 'title',
                'fields' => array(
                    array(
                        'label' => __( 'Title', 'sonno' ),
                        'id' => 'title',
                        'type' => 'text',
                    ),
                    array(
                        'label' => __( 'Percentage', 'sonno' ),
                        'id' => 'percentage',
                        'type' => 'text',
                    ),
                    
                    array(
                        'label' => __( 'Button Type', 'sonno' ),
                        'id' => 'btn_type',
                        'type' => 'select',
                        'options' => array(
                            'btn-default' => __( 'default', 'sonno' ),
                            'btn-primary' => __( 'Primary', 'sonno' ),
                            'btn-success' => __( 'Success', 'sonno' ),
                            'btn-info' => __( 'Info', 'sonno' ),
                            'btn-warning' => __( 'Warning', 'sonno' ),
                            'btn-danger' => __( 'Danger', 'sonno' ),
                            'btn-link' => __( 'Link', 'sonno' ),
                            'btn-quaternary' => __( 'Quaternary', 'sonno' ),
                            'btn-tertiary' => __( 'Tertiary', 'sonno' ),
                            'btn-secondary' => __( 'Secondary', 'sonno' ),
                        )
                    )
                )
            ),
            
            array(
        		'label' => __( 'Image Big', 'sonno' ),
        		'id' => 'spyropress_img_big',
                'type' => 'checkbox',
                'options' => array(
                    '1' => __( 'Enable Feature Image Size Big', 'sonno' ),
                )
        	),
            
            array(
                'label' => __( 'Display','sonno' ),
                'id' => 'display',
                'desc' => __( 'Select the option to display','sonno' ),
                'class' => 'enable_changer section-full',
                'type' => 'select',
                'options' => array( 'gallery' => 'Gallery', 'video' => 'Video' )
            ),

            array(
                'label' => __( 'Video','sonno' ),
                'id' => 'video',
                'desc' => __( 'This enable you to embed videos into your portfolio pages.','sonno' ),
                'class' => 'display video',
                'type' => 'textarea',
                'rows' =>  3
            ),

            array(
                'label' => __( 'Gallery','sonno' ),
                'id' => 'gallery',
                'desc' => __( 'Set up your gallery.','sonno' ),
                'class' => 'display gallery',
                'type' => 'gallery'
            )
        );
        
        $post->add_meta_box( 'portfolio', __( 'Portfolio Details', 'sonno' ), $meta_fields, '_portfolio_details', false );
    }
    
    function register_module( $modules ) {

        $modules[] = $this->path . '/module/module.php';

        return $modules;
    }
}

/**
 * Init the Component
 */
new SpyropressPortfolio();