<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
if ( current_theme_supports( 'post-thumbnails' ) && has_post_thumbnail() ) { $thumbURL = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), '480p' ); $img = $thumbURL[0]; };
?>
<li class="prdct-itm prdct col-lg-3 col-md-6 col-sm-6 col-12 trnstn" itemprop="itemListElement" itemscope itemtype="http://schema.org/Product">
    
    <link itemprop="url" href="<?php echo the_permalink(); ?>" />
    <div class="innr">
        <div class="ftrd-img">
            <a href="<?php echo the_permalink(); ?>" class="lnk-hrf">
                <img class="img" itemprop="image" src="<?php echo $img; ?>" />
            </a>
        </div>
        <div class="mta">
            <div class="nme">
                <h3 itemprop="name"><a itemprop="url" href="<?php echo the_permalink(); ?>"><?php echo the_title(); ?></a></h3>
            </div>
            <div class="offrs" itemprop="offers" itemscope itemtype="http://schema.org/Offer">
                <?php if ( $price_html = $product->get_price_html() ) : ?>
                <span class="price"><?php echo $price_html; ?></span>
                <?php endif; ?>
            </div>
            <?php
            $addtcrt = $product->add_to_Cart_url();
            $idp = $product->get_id();
            ?>
            <a rel="nofollow" class="add-to-cart product_type_simple add_to_cart_button ajax_add_to_cart" data-quantity="1" data-product_id="<?php echo $idp; ?>" data-product_sku="" itemprop="url" href="<?php echo $addtcrt; ?>">
                <span>Agregar al Carro</span>
            </a>
            
        </div>
    </div>

</li>