<?php

/*    METABOX: SLIDER
/*-----------------------------------------------------------------------------------*/


function adt_add_slide_metabox() {
	add_meta_box( 'Slide', __('Información Slide'), 'adt_slide_metabox_inner', 'slider', 'normal' , 'high' );
}

add_action( 'add_meta_boxes', 'adt_add_slide_metabox' );

add_action( 'save_post', 'adt_slide_metabox_save' );

function adt_slide_metabox_inner( $post ) {
	
    global $post, $post_vals;
	
    $post_vals = get_post_custom( $post->ID );
	
    $sliderTitulo       = isset( $post_vals['sliderTitulo'] ) ?       esc_attr( $post_vals['sliderTitulo'][0] ) : '';
	$sliderLinkUrl      = isset( $post_vals['sliderLinkUrl'] ) ?      esc_attr( $post_vals['sliderLinkUrl'][0] ) : '';
	$sliderBotonTitulo  = isset( $post_vals['sliderBotonTitulo'] ) ?  esc_attr( $post_vals['sliderBotonTitulo'][0] ) : '';

    wp_nonce_field( 'slide_meta_box_nonce', 'slide-meta-box-nonce' );

?>

<form method="post" action="options.php">
	<div class="table-slides">
		<div class="slide-item">
			<div class="slide-title"><label for="sliderTitulo"><strong><?php _e( 'Titulo' ); ?></strong></label></div>
			<div class="slide-content"><input type="text" id="sliderTitulo" name="sliderTitulo" value="<?php echo $sliderTitulo; ?>"></div>
		</div>
		<div class="slide-item">
			<div class="slide-title"><label for="sliderLinkUrl"><strong><?php _e( 'URL' ); ?></strong></label></div>
			<div class="slide-content"><input type="text" placeholder="Añadir la url con http://www..." id="sliderLinkUrl" name="sliderLinkUrl" value="<?php echo $sliderLinkUrl; ?>"></div>
		</div>
		<div class="slide-item">
			<div class="slide-title"><label for="sliderBotonTitulo"><strong><?php _e( 'Titulo Botón' ); ?></strong></label></div>
			<div class="slide-content"><input type="text" id="sliderBotonTitulo" name="sliderBotonTitulo" value="<?php echo $sliderBotonTitulo; ?>"></div>
		</div>
	</div>
</form>

<?php }

function adt_slide_metabox_save( $post_id )  {
	if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
    if( !isset( $_POST['slide-meta-box-nonce'] ) || !wp_verify_nonce( $_POST['slide-meta-box-nonce'], 'slide_meta_box_nonce' ) ) return; 
    if( !current_user_can( 'edit_post', $post_id ) )return;	
	
	
	if( isset( $_POST['sliderTitulo'] ) )  
		update_post_meta( $post_id, 'sliderTitulo', esc_attr( $_POST['sliderTitulo'] ) );
    
	if( isset( $_POST['sliderLinkUrl'] ) )  
		update_post_meta( $post_id, 'sliderLinkUrl', esc_attr( $_POST['sliderLinkUrl'] ) );
		
	if( isset( $_POST['sliderBotonTitulo'] ) )  
		update_post_meta( $post_id, 'sliderBotonTitulo', esc_attr( $_POST['sliderBotonTitulo'] ) );
}

/*    METABOX: SHORT PAGE DESCRIPTION
/*-----------------------------------------------------------------------------------*/


function jlga_add_subtitle_metabox() {
	add_meta_box( 'jlga-settings-main', __('Subtitulo'), 'jlga_subtitle_metabox_inner', 'page' , 'advanced' , 'high' );
	add_meta_box( 'jlga-settings-main', __('Subtitulo'), 'jlga_subtitle_metabox_inner', 'post' , 'advanced' , 'high' );
}

add_action( 'add_meta_boxes', 'jlga_add_subtitle_metabox'  );
add_action( 'save_post',      'jlga_subtitle_metabox_save' );

function jlga_subtitle_metabox_inner( $post ) {
    
    global $post, $post_vals;
    $post_vals = get_post_custom( $post->ID );
    $page_sub_title = isset( $post_vals['page_sub_title'] ) ? esc_attr( $post_vals['page_sub_title'][0] ) : '';
    
	wp_nonce_field( 'jlga_meta_box_nonce', 'jlga-meta-box-nonce' ); 
?>

<div class="w-100" style="width:100%;">
    <input type="text" id="page_sub_title" class="cstm-inpt" name="page_sub_title" value="<?php echo $page_sub_title; ?>">
</div>

<?php }

function jlga_subtitle_metabox_save( $post_id )  {
    
    if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return; 
    if( !isset( $_POST['jlga-meta-box-nonce'] ) || !wp_verify_nonce( $_POST['jlga-meta-box-nonce'], 'jlga_meta_box_nonce' ) ) return; 
    if( !current_user_can( 'edit_post', $post_id ) )return;	
    
    if( isset( $_POST['page_sub_title'] ) ) update_post_meta( $post_id, 'page_sub_title', esc_attr( $_POST['page_sub_title'] ) );

}

?>