<?php

/*    CUSTOM GALLERY
/*-----------------------------------------------------------------------------------*/

add_filter('post_gallery', 'my_post_gallery', 10, 2);
function my_post_gallery($output, $attr) {
    global $post;

    if (isset($attr['orderby'])) {
        $attr['orderby'] = sanitize_sql_orderby($attr['orderby']);
        if (!$attr['orderby'])
            unset($attr['orderby']);
    }

    extract(shortcode_atts(array(
        'order' => 'ASC',
        'orderby' => 'menu_order ID',
        'id' => $post->ID,
        'itemtag' => 'dl',
        'icontag' => 'dt',
        'captiontag' => 'dd',
        'columns' => 3,
        'size' => 'thumbnail',
        'include' => '',
        'exclude' => ''
    ), $attr));

    $id = intval($id);
    if ('RAND' == $order) $orderby = 'none';

    if (!empty($include)) {
        $include = preg_replace('/[^0-9,]+/', '', $include);
        $_attachments = get_posts(array('include' => $include, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby));

        $attachments = array();
        foreach ($_attachments as $key => $val) {
            $attachments[$val->ID] = $_attachments[$key];
        }
    }

    if (empty($attachments)) return '';
    
    // Here's your actual output, you may customize it to your need
    $output =  "<div class=\"sldshw-wrppr\">\n";
    $output .= "<ul id=\"imgGllry\" class=\"adt-gallery adt-gallery-{$post->ID}\">\n";

    // Now you loop through each attachment
    foreach ($attachments as $id => $attachment) {
        // Fetch the thumbnail (or full image, it's up to you)
        $imgthmb = wp_get_attachment_image_src($id, 'thumbnail');
        $img = wp_get_attachment_image_src($id, '560p');
        $imghd = wp_get_attachment_image_src($id, '720p');

		$output .= "<li class=\"itm-img-gllry\" data-thumb=\"{$imgthmb[0]}\" data-src=\"{$imghd[0]}\" >\n";
        $output .= "<img class=\"img-fllwth\" src=\"{$img[0]}\" />\n";
		$output .= "</li>\n";
    }

    $output .= "</div>\n";
    $output .= "</ul>\n";

    return $output;
}

?>