<?php

// FUNCTION:
// REMOVE WORDPRESS ADMIN BAR (UNCOMMENTS NEXT LINE TO ACTIVATE)
// add_filter('show_admin_bar', '__return_false');



// FUNCTION:
// REMOVE DEFAULT THUMBNAIL SIZES
function remove_default_image_sizes( $sizes) {
    unset($sizes['medium']);
    unset($sizes['large']);
    return $sizes;
}
add_filter('intermediate_image_sizes_advanced','remove_default_image_sizes');
if ( function_exists( 'add_theme_support' ) ) add_theme_support( 'post-thumbnails' );
if ( function_exists( 'add_image_size' ) ) {
    add_image_size( 'full-size',  9999, 9999, false );
	add_image_size( '90p',  90, 70, true );
    add_image_size( '480p',  480, 480, true );
    add_image_size( '720p',  720, 720, false );
    add_image_size( '1280p', 1280, 1280, false );
};



// FUNCTION:
// CUSTOM STYLESHEET ON WORDPRESS ADMIN
function load_custom_wp_admin_style() {
    wp_register_style( 'custom_wp_admin_css', get_template_directory_uri() . '/assets/css/custom.css', false, '1.0.0' );
	wp_enqueue_style( 'custom_wp_admin_css' );
}
add_action( 'admin_enqueue_scripts', 'load_custom_wp_admin_style' );



// FUNCTION:
// ADD HOME LINK TO WORDPRESS MENU EDITOR
function home_page_menu_args( $args ) {
    $args['show_home'] = true;
    return $args;
}
add_filter( 'wp_page_menu_args', 'home_page_menu_args' );



// FUNCTION:
// REGISTER MENUS SECTIONS AND NAMES
register_nav_menus( array( 
    'menu'=>__('Menu'), 
    'menu_hidden'=>__('Menu Oculto'), 
    'footer'=>__('Footer'), )
);



// FUNCTTION:
// CUSTOM EXCERPT
function excerpt($limit) {
    
    $excerpt = explode(' ', get_the_excerpt(), $limit);
    if (count($excerpt)>=$limit) {
        array_pop($excerpt);
        $excerpt = implode(" ",$excerpt).'...';
    } else {
        $excerpt = implode(" ",$excerpt);
    }
    $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
    return $excerpt;
}
function content($limit) {
    $content = explode(' ', get_the_content(), $limit);
    if (count($content)>=$limit) {
        array_pop($content);
        $content = implode(" ",$content).'...';
    } else {
        $content = implode(" ",$content);
    }
    $content = preg_replace('/[.+]/','', $content);
    $content = apply_filters('the_content', $content);
    $content = str_replace(']]>', ']]&gt;', $content);
    return $content;
}



// FUNCTION:
// INSERT IMAGES HTML STRUCTURE
function html5_insert_image($html, $id, $caption, $title, $align, $url) {
    
    $url = wp_get_attachment_url($id);
    $html5 = "<figure id='media-$id' class='align-$align'>";
    $html5 .= "<img class='trnstn' src='$url' data-original='$url' alt='$title' />";
    if ($caption) {
        $html5 .= "<figcaption>$caption</figcaption>";
    }
    $html5 .= "</figure>";
    return $html5;
}
add_filter( 'image_send_to_editor', 'html5_insert_image', 10, 9 );



// FUNCTION:
// EMBED VIDEOS HTML STRUCTURE
add_filter('embed_oembed_html', 'my_embed_oembed_html', 99, 4);
function my_embed_oembed_html($html, $url, $attr, $post_id) {
    return '<div class="ntry-vdo"><div class="vdo-innr">' . $html . '</div></div>';
};



// FUNCTION:
// REMOVE PAGES FROM SEARCH RESULTS
function remove_pages_from_search() {
    global $wp_post_types;
    $wp_post_types['page']->exclude_from_search = true;
}
add_action('init', 'remove_pages_from_search');


// FUNCTION
// ADD FAVICON TO ADMIN AND LOGIN PAGES
function add_favicon() {
  	$favicon_url = get_stylesheet_directory_uri() . '/assets/img/favicon/favicon.ico';
	echo '<link rel="shortcut icon" href="' . $favicon_url . '" />';
}  
add_action('login_head', 'add_favicon');
add_action('admin_head', 'add_favicon');

?>