<!DOCTYPE html>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 7) | !(IE 8)  ]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->
<head itemscope itemtype="http://schema.org/WebSite">
    
    <?php include(TEMPLATEPATH . '/include/wp_head/head_title.php'); ?>
    
    <?php include(TEMPLATEPATH . '/include/wp_head/head_responsive.php'); ?>
    
    <?php include(TEMPLATEPATH . '/include/wp_head/head_favicon.php'); ?>
    
    <?php include(TEMPLATEPATH . '/include/wp_head/head_meta.php'); ?>
    
    <?php include(TEMPLATEPATH . '/include/wp_head/head_css-fonts.php'); ?>
    
    <?php include(TEMPLATEPATH . '/include/wp_head/head_javascripts.php'); ?>

    <?php if ( is_single() || is_page() ) wp_enqueue_script( 'comment-reply' ); ?>
    <?php wp_head(); ?>

    <?php include(TEMPLATEPATH . '/include/wp_head/head_iexplorer.php'); ?>

    <?php include(TEMPLATEPATH . '/include/wp_head/head_javascripts-b.php'); ?>

    <!-- Google Tag Manager -->
    <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
    new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
    j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
    'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
    })(window,document,'script','dataLayer','GTM-577XNWM');</script>
    <!-- End Google Tag Manager -->
    
</head>
<body itemscope itemtype="http://schema.org/WebPage" <?php body_class(); ?>>

    <!-- Google Tag Manager (noscript) -->
    <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-577XNWM"
    height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
    <!-- End Google Tag Manager (noscript) -->
    
    <div id="mn" class="mn-pg trnstn" data-info-page="page">
        
        <div class="mn-innr innr-pg mn-hldr-lft trnstn">
            
           <!-- nav hidden -->
            <div class="hddn-nv trnstn">
                <div class="scrll-br">
                    <div class="cntnr trnstn">
                        <?php wp_nav_menu( array(
                        'theme_location' => 'menu_hidden',
                        'container' => '',
                        'sort_column' => 'menu_order',
                        'menu_id' => 'mn-hddn-lst',
                        'fallback_cb' => 'default_menu',
                        'walker'  => new WPDocs_Walker_Nav_Menu(), ));
                        ?>
                    </div>
                </div>
            </div>

            <!-- main header -->
            <header id="mn-hdr" class="bg-grdnt trnstn" role="banner">
                
                <div class="innr-flx">
                    
                    <!-- nav visible -->
                    <div class="vsbl-nv trnstn">
                        
                        <div class="hdr-sctn-lft">
                            
                            <!-- nav icon -->
                            <div id="nv-icn" class="nv-sndwch">
                                <span></span>
                                <span></span>
                                <span></span>
                                <span></span>
                            </div>

                            <!-- logo -->
                            <div id="mn-lgo" class="transition">
                                
                                <a href="<?php bloginfo('url') ?>/" itemprop="url">
                                    <img itemprop="image" src="https://www.reczoom.cl/wp-content/uploads/2023/09/Logo-2.png" />
                                </a>

                            </div>
                            
                        </div>
                        
                        <div class="hdr-sctn-rght">
                            
                            <!-- nav section top -->
                            <div class="w-100 dsply-flx jstfy-spc-btwn trnstn">

                                <form class="tp-srch-frm" method="get" action="<?php echo home_url( '/' ); ?>" role="search">
                                    <input type="text" name="s" class="srch-inpt  js-srch-npt" placeholder="Buscar..." autocomplete="off" value="">
                                    <button class="srch-bttn" id="searchsubmit"><i class="fa fa-search"></i></button>
                                </form>
                                                      
                                <div class="usr-lggd-n">
                                    <ul class="usr-lst-mn">
                                        <li class="item-inicio"    itemscope="" itemtype="http://schema.org/CreativeWork">
                                            <a href="<?php bloginfo('url'); ?>" class="menu-link main-menu-link" itemprop="url"><i class="fas fa-home"></i></a>
                                        </li>
                                    </ul>
                                </div>

                            </div>

                            <!-- nav section bottom -->
                            <div class="w-100 nvrln trnstn">
                                
                                <?php
                                
                                wp_nav_menu( array(
                                'theme_location' => 'menu',
                                'container' => '',
                                'sort_column' => 'menu_order',
                                'menu_id' => 'mn-lst',
                                'menu_class' => 'rst-icns-mn',
                                'fallback_cb' => 'default_menu',
                                'walker'  => new WPDocs_Walker_Nav_Menu(), ));
                                
                                ?>
                                                                
                            </div>
                            
                        </div>
                        
                    </div>
                                        
                </div>

            </header>