<?php
	if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
		die ('Please do not load this page directly. Thanks!');
	if ( post_password_required() ) { ?>
		<p class="nocomments"><?php _e('This post is password protected. Enter the password to view comments.'); ?></p>
	<?php
		return;
	}
?>
<!-- You can start editing here. -->
<?php if ( comments_open() ) : ?>
<div id="commentsbox">
    <?php if ( comments_open() ) : ?>
    <div id="comment-form">
        <div id="respond" >
            <div class="comments-head">
                <h3 id="comments-respond"><?php comments_number(__('0 Comentarios'), __('1 Comentario'), __('% Comentarios') );?></h3>
                <?php if ( is_user_logged_in() ) : ?>
                <span class="logout-acount">
                    <a class="disconect-user-log" href="<?php echo wp_logout_url(get_permalink()); ?>" title="<?php _e('Log out of this account'); ?>"><?php _e('Log out'); ?></a>
                </span>
                <?php else: ?>
                <?php endif; ?> 
            </div>
            <div class="cancel-comment-reply">
                <?php cancel_comment_reply_link(); ?>
            </div>
            <?php if ( get_option('comment_registration') && !is_user_logged_in() ) : ?>
                <p><?php _e('Si tu comentar quieres,'); ?> <a href="<?php echo wp_login_url( get_permalink() ); ?>"><?php _e('logearte'); ?></a><?php _e(' en la página debes.'); ?></p>
            <?php else : ?>
            <form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform" >
                <?php if ( is_user_logged_in() ) : ?>
                    <?php // aqui va el avatar ?>
                    <div id="comments-body">
                        <div class="comments-content">
                            <textarea name="comment" id="comment" col0"45" rows="12" tabindex="4" placeholder="¿Qué Opinas? ¡Cuentanos!"></textarea><br />
                            <button type="submit" id="commentSubmit" class="button light-gray"><span><?php _e('Comentar' ); ?></span></button>
                            <input name="submit" type="hidden" tabindex="5" value="<?php _e('Comentar' ); ?>" />
                        </div>
                    </div>
                <?php else : ?>
                    <?php // aquí va si no estás logeado ?>
                    <input type="text" name="author" id="author" value="<?php if ($comment_author == '') { echo _e('Username' ); echo '*'; } elseif ($comment_author >= '') { echo $comment_author; } ?>" onfocus="if(this.value=='<?php _e('Username' ); ?>*')this.value='';" onblur="if(this.value=='')this.value='<?php _e('Username' ); ?>*';" size="22" tabindex="1" />
                    <br />
                    <input type="text" name="email" id="email" value="<?php if ($comment_author_email == '') { echo _e('Email' ); echo '*'; } elseif ($comment_author_email >= '') { echo $comment_author_email; } ?>" onfocus="if(this.value=='<?php _e('Email' ); ?>*')this.value='';" onblur="if(this.value=='')this.value='<?php _e('Email' ); ?>*';" size="2" tabindex="2" />
                    <br />
                    <input type="text" name="url" id="url" value="<?php if ($comment_author_url == '') { echo _e('Website' ); } elseif ($comment_author_url >= '') { echo $comment_author_url; } ?>" onfocus="if(this.value=='<?php _e('Website' ); ?>')this.value='';" onblur="if(this.value=='')this.value='<?php _e('Website' ); ?>';" size="2" tabindex="3" />
                    <br />
                    <textarea name="comment" id="comment" col0"45" rows="12" tabindex="4" placeholder="¿Qué Opinas? ¡Cuentanos!"></textarea><br />
                    <button type="submit" id="commentSubmit" class="button light-gray"><span><?php _e('Comentar' ); ?></span></button>
                    <input name="submit" type="hidden" tabindex="5" value="<?php _e('Comentar' ); ?>" />
                <?php endif; ?>
                <?php comment_id_fields(); ?>
                <?php do_action('comment_form', $post->ID); ?>
            </form>
            <?php endif;
            // registration required and not logged in ?>
        </div>
    </div>    
	<?php if ( have_comments() ) : ?>
    <ol class="commentlist">
    <?php wp_list_comments(
	array(
		'avatar_size' => 40,
	));
    ?>
    </ol>
    <div class="comment-nav">
        <div class="alignleft"><?php previous_comments_link() ?></div>
        <div class="alignright"><?php next_comments_link() ?></div>
    </div>
    <?php endif; ?>
    <?php else :
    // comments are closed ?>
    <?php endif; ?>
</div>
<?php else :
// comments are closed ?>
<?php endif;
// delete me and the sky will fall on your head ?>