<?php
/**
 * Twitter Module
 * Display an official Twitter Embedded Timeline.
 *     
 * @package		SpyroPress
 * @category	Module
 * @author		SpyroSol
 */

use Abraham\TwitterOAuth\TwitterOAuth;

class SpyroPress_Module_Twitter extends SpyropressBuilderModule {

    private $_api_url = 'https://api.twitter.com/1/';

    /**
     * Constructor
     */

    function __construct() {

        // Widget variable settings.
        $this->id_base = 'spyropress_twitter';
        $this->name = __( 'Twitter', 'spyropress' );
        $this->cssclass = 'Twiter';
        $this->description = __( 'Display an official Twitter Embedded Timeline.', 'spyropress' );

        $this->fields = array(

            array(
                'label' => __( 'Username', 'spyropress' ),
                'id' => 'username',
                'type' => 'text'
            ),
            
            array(
                'label' => __( 'Post Count', 'spyropress' ),
                'id' => 'twitter_counts',
                'type' => 'range_slider',
                'max' => 20,
                'std' => 5
            ),
        );

        $this->create_widget();
    }

    function widget( $args, $instance ) {

        // extracting info
        extract( $args );extract( spyropress_clean_array( $instance ) );

        // get view to render
        include $this->get_view();

    }

    function get_tweets( $username = '', $count = false ) {

    	$defaults = array(
	        'lang' => substr( strtoupper( get_locale() ), 0, 2 ),
	        'post_count' => $count ? $count : 10,
	        'username' => $username ? $username : get_setting( 'twitter_username' ),
	        'consumer_key' => get_setting( 'twitter_consumer_key' ),
	        'consumer_secret' => get_setting( 'twitter_consumer_secret' ),
	        'access_token' => get_setting( 'twitter_access_token' ),
	        'access_token_secret' => get_setting( 'twitter_access_token_secret' )
	    );

	    extract( $defaults );

	    $key = '_spyropress_' . $username . '_tweets_' . $post_count;

	    if( ! $consumer_key || ! $consumer_secret || ! $access_token || ! $access_token_secret ) {
	        echo 'No oAuth setting provided.';
	        exit;
	    }

	    $tweets = array();
	    if( false === ( $tweets = get_transient( $key ) ) ) {

	        require_once 'twitteroauth/autoload.php';
	        $twitterConnection = new TwitterOAuth( $consumer_key, $consumer_secret, $access_token, $access_token_secret );

	    	$tweets = $twitterConnection->get(
	    			  'statuses/user_timeline',
	    			  array(
	    			    'screen_name'     => $username,
	    			    'count'           => $post_count,
	    			  )
	    	);

	    	if($twitterConnection->getLastHttpCode() != 200) {
	    		$tweets = get_transient( $key );
	    	}

	        // Cache
	        set_transient( $key, $tweets, spyropress_get_seconds( 0.1 ) );

	    }

	    return $tweets;

    }

    function convert_links( $status, $targetBlank=true, $linkMaxLen=250 ) {

		// the target
		$target = $targetBlank ? " target=\"_blank\" " : "";

		// convert link to url
		$status = preg_replace( '/\b(http|https?|ftp|file):\/\/[-A-Z0-9+&@#\/%?=~_|!:,.;]*[A-Z0-9+&@#\/%=~_|]/i', '<a href="\0" target="_blank">\0</a>', $status );

		// convert @ to follow
		$status = preg_replace( "/(@([_a-z0-9\-]+))/i","<a href=\"http://twitter.com/$2\" title=\"Follow $2\" target=\"_blank\" >$1</a>",$status );

		// convert # to search
		$status = preg_replace( "/(#([_a-z0-9\-]+))/i","<a href=\"https://twitter.com/search?q=$2\" title=\"Search $1\" target=\"_blank\" >$1</a>",$status );

		return $status;

	}

} // class SpyroPress_Module_Twitter

spyropress_builder_register_module( 'SpyroPress_Module_Twitter' );