<?php
/**
 * Module: Testimonials
 * Display a list of testimonials
 *
 * @author 		SpyroSol
 * @category 	BuilderModules
 * @package 	Spyropress
 */

class Spyropress_Widget_Recent_Testimonials extends SpyropressBuilderModule {

    public function __construct() {

        // Widget variable settings.
        $this->path = dirname( __FILE__ );
        $this->description = __( 'Display a list of testimonials.', 'sonno' );
        $this->id_base = 'recent_testimonials';
        $this->name = __( 'Testimonials', 'sonno' );

        // Fields
        $this->fields = array(

            array(
                'label' => __( 'Number of items', 'sonno' ),
                'id' => 'limit',
                'type' => 'range_slider',
                'std' => 4
            ),


            array(
                'label' => __( 'Category', 'sonno' ),
                'id' => 'cat',
                'type' => 'multi_select',
                'options' => spyropress_get_taxonomies( 'testimonial_category' )
            )
            
        );

        $this->create_widget();
    }

    function widget( $spyropress_args, $spyropress_instance ) {

        // extracting info
        extract( $spyropress_args ); extract( $spyropress_instance );
        
        //Required View File
        require( $this->get_view() ); 
    }

    function query( $atts, $content = null ) {

        $default = array (
            'post_type' => 'testimonial',
            'limit' => -1,
            'columns' => false,
            'row' => false,
            'pagination' => false,
            'callback' => array( $this, 'spyropress_generate_item' )
        );
        $atts = wp_parse_args( $atts, $default );

        if ( ! empty( $atts['cat'] ) ) {

            $atts['tax_query']['relation'] = 'OR';
            if ( ! empty( $atts['cat'] ) ) {
                $atts['tax_query'][] = array(
                    'taxonomy' => 'testimonial_category',
                    'field' => 'slug',
                    'terms' => $atts['cat'],
                    );
                unset( $atts['cat'] );
            }
        }

        if ( $content )
            return token_repalce( $content, spyropress_query_generator( $atts ) );

        return spyropress_query_generator( $atts );
    }
    
    function spyropress_generate_item ( $post_ID, $atts ) {
        
        //testimonial meta data.
        $spyropress_data = get_post_meta( $post_ID, '_testimonial', true );
        
        //testimonial gratvar.
        $spyropress_image = '';
        if( has_post_thumbnail() ){
            $spyropress_image =  '<div class="avatar">'. spyropress_get_image( array( 'class' => 'img-responsive', 'echo' => false ) ) .'</div>';  
        }
        
        //testimonial text.
        $spyropress_testimonial = isset( $spyropress_data['spyropress_testimonial'] )? '<p>'. wp_kses( $spyropress_data['spyropress_testimonial'], array( 'br' => array() ) ) .'</p>' : '';
        $spyropress_site = isset( $spyropress_data['spyropress_site'] )? ' - <a href="'. esc_url( $spyropress_data['spyropress_site'] ) .'">'. esc_html( $spyropress_data['spyropress_site'] ) .'</a>' : '';
                
        // item tempalte
        $item_tmpl = '
        <div class="item-testimonial">
            '. $spyropress_image .'
            <div class="content">
                <blockquote>
                    ' . $spyropress_testimonial .'    
                    <footer>'. get_the_title() . $spyropress_site .'</footer>
                </blockquote>
            </div>
        </div>';

        return $item_tmpl;
    }

}
//Register Module Class Spyropress_Widget_Recent_Testimonials
spyropress_builder_register_module( 'Spyropress_Widget_Recent_Testimonials' );