<?php

/**
 * Staff Component
 * 
 * @package		SpyroPress
 * @category	Components
 */

class SpyropressStaff extends SpyropressComponent {

    private $path;
    
    function __construct() {

        $this->path = dirname(__FILE__);
        add_action( 'spyropress_register_taxonomy', array( $this, 'register' ) );
        add_filter( 'builder_include_modules', array( $this, 'register_module' ) );
    }

    function register() {

        // Init Post Type
        $args = array(
            'title'     => __( 'Enter name here..', 'sonno' ),
            'public'    => false,
            'supports'  => array( 'title', 'thumbnail' ),
            'menu_icon' => 'dashicons-admin-users'
        );
        $post = new SpyropressCustomPostType( 'Staff', 'staff', $args );

        // Add Taxonomy
        $post->add_taxonomy( __( 'Staff Category', 'sonno' ), 'staff_category', __( 'Staff Categories', 'sonno' ), array( 'hierarchical' => true ) );
        $post->add_taxonomy( 'Designation', '', '', array( 'hierarchical' => false ) );
         
        // Add Meta Boxes
        $meta_fields['staff'] = array(
        
            array(
                'label' => __( 'Staff', 'sonno' ),
                'type' => 'heading',
                'slug' => 'staff'
            ),


            array(
                'label' => __(  'Social Icons', 'sonno' ),
                'id' => 'social_icons',
                'type' => 'repeater',
                'item_title' => 'network',
                'fields' => array(
                
                    array(
                        'label' => __( 'Network', 'sonno' ),
                        'id' => 'network',
                        'type' => 'select',
                        'options' => spyropress_get_options_social()
                    ),
                    array(
                        'label' => __( 'Link', 'sonno' ),
                        'id' => 'link',
                        'type' => 'text'
                    )
                )
            ),
            
            array(
                'label' => __( 'Type', 'sonno' ),
                'id' => 'type',
                'type' => 'select',
                'options' => array(
                    'primary' => __( 'Primary', 'sonno' ),
                    'secondary' => __( 'Secondary', 'sonno' ),
                    'tertiary' => __( 'Tertiary', 'sonno' ),
                    'quaternary' => __( 'Quaternary', 'sonno' )
                ),'std' => 'primary'
            )
        );

        $post->add_meta_box( 'staff_info', __( 'Mate Information', 'sonno' ), $meta_fields, '_mate_info', false );
    }
    
    function register_module( $modules ) {

        $modules[] = $this->path . '/module/staff.php';

        return $modules;
    }
}

/**
 * Init the Component
 */
new SpyropressStaff();
?>