<?php
/**
 * Page Component
 * 
 * @package		SpyroPress
 * @category	Components
 */
class SpyropressPage extends SpyropressComponent {
    private $path;

    function __construct() {
        $this->path = dirname(__FILE__);
        add_action( 'spyropress_register_taxonomy', array( $this, 'register' ) );
    }

    function register() {

        // Init Post Type
        $post = new SpyropressCustomPostType( 'Page' );
        $menus = wp_get_nav_menus();
        $menu_options = array();

        if ( isset( $menus ) && count( $menus ) > 0 ) {
            foreach ( $menus as $menu ) {
                $menu_options[$menu->term_id] = $menu->name;
            }
        }

        // Add Meta Boxes
        $meta_fields['options'] = array(

            array(
                'label' => __( 'Slider', 'sonno' ),
                'type' => 'heading',
                'slug' => 'options'
            ),

            array(
                'label' => __( 'OnePage Menu', 'sonno' ),
                'id' => 'onepage_menu',
                'type' => 'select',
                'class' => 'page_template one-page-php',
                'options' => $menu_options
            ),

            array(
                'label' => __( 'Slider', 'sonno' ),
                'type' => 'sub_heading',
            ),
            
            array(  
                'label' => __( 'Slider', 'sonno' ),
                'id' => 'slider',
                'desc' => __( 'Select a slider for site page' , 'sonno' ),
                'type' => 'select',                
                'options' =>  $this->spyropress_get_sliders()
            ),
            
            array(
                'label' => __( 'Page Breadcrumb', 'sonno' ),
                'id' => 'breadcrumb',
        	    'type' => 'checkbox',
        	    'options' => array(
            		'1' => __( 'Disable Page Breadcrumb.', 'sonno' ),
       	        )
            ),
            
            array(
                'label' => __( 'Page Comments', 'sonno' ),
                'id' => 'comments',
        	    'type' => 'checkbox',
        	    'options' => array(
            		'1' => __( 'Disable Page Comments.', 'sonno' ),
       	        )
            )
        );
        
        $post->add_meta_box( 'page_options', __( 'Page Options', 'sonno' ), $meta_fields, '_page_options', false, 'normal', 'high' );
    }
    
    /**
     * Data Source - Sliders
     */
    function spyropress_get_sliders() {
        
        $sliders = array();
        
        if ( ! post_type_exists( 'slider' ) ) return $sliders;
        
        // get posts
        $args = array(
            'post_type' => 'slider',
            'posts_per_page' => -1,
            'orderby' => 'title',
            'order' => 'asc'
        );
        $posts = get_posts( $args );
        if ( !empty( $posts ) ) {
            foreach ( $posts as $post ) {
                $sliders[$post->ID] = $post->post_title;
            }
        }
    
        return $sliders;
    }
}

/**
 * Init the Component
 */
new SpyropressPage();